dofile(LockOn_Options.script_path.."command_defs.lua")
dofile(LockOn_Options.script_path.."devices.lua") -- "script_path" is main scripts folder. common is local.

local rate = 0.5
make_default_activity(rate) -- gets plane info

local Data = get_base_data() 

local dev = GetSelf()

function post_initialize()
	smoke_on = false
	smoke_press = false
	smoke_armed = false
	smoke_equipped0 = false
	smoke_equipped8 = false
	smoke_equipped = false
	messagesent = false
	safemessagesent = false
	
	--Smokes
	Smoke1 = "{A4BCC903-06C8-47bb-9937-A30FEDB4E741}"
	Smoke2 = "{A4BCC903-06C8-47bb-9937-A30FEDB4E742}"
	Smoke3 = "{A4BCC903-06C8-47bb-9937-A30FEDB4E743}"
	Smoke4 = "{A4BCC903-06C8-47bb-9937-A30FEDB4E744}"
	Smoke5 = "{A4BCC903-06C8-47bb-9937-A30FEDB4E745}"
	Smoke6 = "{A4BCC903-06C8-47bb-9937-A30FEDB4E746}"
end

dev:listen_command(7010) 

function Logic()


	-- check if smoke winders fitted
	ST0 = dev:get_station_info(0)
	ST0CLSID = ST0.CLSID
	
	if((ST0CLSID == Smoke1) or (ST0CLSID == Smoke2) or (ST0CLSID == Smoke3) or (ST0CLSID == Smoke4) or (ST0CLSID == Smoke5) or (ST0CLSID == Smoke6)) then --If a smoke pod is on the 1 pylon
		smoke_equipped0 = true
	else
		smoke_equipped0 = false
	end
		
	ST8 = dev:get_station_info(8)
	ST8CLSID = ST8.CLSID
	
	if((ST8CLSID == Smoke1) or (ST8CLSID == Smoke2) or (ST8CLSID == Smoke3) or (ST8CLSID == Smoke4) or (ST8CLSID == Smoke5) or (ST8CLSID == Smoke6)) then --If a smoke pod is on the 8 pylon
		smoke_equipped8 = true
	else
		smoke_equipped8 = false
	end
		
	if smoke_equipped0 == true or smoke_equipped8 == true then --If a smoke pod is on any pylon
		smoke_equipped = true
	else
		smoke_equipped = false
	end
	
	--Check if master arm is on
	if get_cockpit_draw_argument_value(49) >= 1 and smoke_equipped == true then
		smoke_armed = true
		safemessagesent = false	
		if smoke_equipped0 == true and messagesent == false then --If a smoke pod is on the 1 pylon
			print_message_to_user("Smoke Armed on pylon 1")
		end
	
		if smoke_equipped8 == true and messagesent == false then --If a smoke pod is on the 9 pylon
			print_message_to_user("Smoke Armed on pylon 9")
		end
		messagesent = true
	
	-- Check if master arm is off
	elseif get_cockpit_draw_argument_value(49) <= 1 and smoke_equipped == true  then
		smoke_armed = false
		messagesent = false	
		if smoke_on == true then
			if smoke_equipped0 == true and safemessagesent == false then --If a smoke pod is on the 1 pylon
				dev:launch_station(0);
			end

			if smoke_equipped8 == true and safemessagesent == false then --If a smoke pod is on the 9 pylon
				dev:launch_station(8);	
			end
			smoke_on = false
		end
		if smoke_equipped == true and safemessagesent == false then --If a smoke pod is on either pylon
			print_message_to_user("Smoke Safe")
			safemessagesent = true
		end
  
	end

	if smoke_press == true and smoke_armed == true then 
		if smoke_equipped0 == true then --If a smoke pod is on the 1 pylon
			dev:launch_station(0);
		end
		if smoke_equipped8 == true then --If a smoke pod is on the 9 pylon
			dev:launch_station(8);	
		end

		if smoke_on == true then
			smoke_on = false
			print_message_to_user("Smoke Off")
		else --If the smoke is off
			smoke_on = true
			print_message_to_user("Smoke On")
		end
	end
	smoke_press=false
end

function SetCommand(command,value)
	
	if (command == 7010) and smoke_equipped == true then --and track_is_reading() == false then -- was 7010
		smoke_press = true  -- Record key press
	end
end

function update() -- Ties into "local rate" at top. Updates twice a second
	Logic()
end

need_to_be_closed = false